<?php
/**
 * Veidotājs: Roberts Blite
 * Mērķis: Šis PHP skripts apstrādā lietotāja reģistrāciju, validējot e-pastu un šifrējot paroli.
 * Apraksts: Skripts saņem ievades datus no reģistrācijas formas, validē e-pasta adresi,
 *           hasho paroli un saglabā lietotāja datus datubāzē. Ja reģistrācija veiksmīga,
 *           lietotājs tiek pāradresēts uz pieslēgšanās lapu.
 */

// Datubāzes savienojuma parametri
$servername = "database-1.cd0m46mqkm83.eu-north-1.rds.amazonaws.com";
$username = "admin";
$password = "HyperX3146!";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Atļautie e-pasta domēni
$valid_domains = ['gmail.com', 'yahoo.com', 'hotmail.com', 'outlook.com', 'inbox.lv', 'mail.lv'];

// Pārbauda, vai forma ir iesniegta
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Iegūst un sanitizē formas datus
    $first_name = $conn->real_escape_string($_POST['first_name']);
    $last_name = $conn->real_escape_string($_POST['last_name']);
    $email = $conn->real_escape_string($_POST['email']);
    $area_code = $conn->real_escape_string($_POST['area_code']);
    $phone_number = $conn->real_escape_string($_POST['phone_number']);
    $contract_number = $conn->real_escape_string($_POST['contract_number']);
    $work_position = $conn->real_escape_string($_POST['work_position']);
    $password = $_POST['password']; // Paroli nehashē, kamēr e-pasts nav pārbaudīts

    // Validē e-pasta adresi
    $email_domain = explode('@', $email)[1] ?? '';
    if (!in_array($email_domain, $valid_domains)) {
        echo "<script>
                alert('Nepareiza e-pasta adrese!');
                window.history.back();
              </script>";
        exit();
    }

    // Pārbauda, vai e-pasts jau eksistē datubāzē
    $check_email_sql = "SELECT id FROM rb_kvalif_signup_410 WHERE email = ?";
    $check_stmt = $conn->prepare($check_email_sql);
    $check_stmt->bind_param("s", $email);
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();

    if ($check_result->num_rows > 0) {
        echo "<script>
                alert('Šis e-pasts jau ir reģistrēts!');
                window.history.back();
              </script>";
        exit();
    }

    // Ja e-pasts ir derīgs un nav izmantots, hasho paroli
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    // Sagatavo SQL vaicājumu lietotāja datu ievietošanai
    $sql = "INSERT INTO rb_kvalif_signup_410 (first_name, last_name, email, area_code, phone_number, contract_number, work_position, password)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssss", $first_name, $last_name, $email, $area_code, $phone_number, $contract_number, $work_position, $hashed_password);

    // Izpilda vaicājumu un pārbauda, vai reģistrācija bija veiksmīga
    if ($stmt->execute()) {
        echo "<script>
                alert('Reģistrācija veiksmīga!');
                window.location.href = '../html/index.html';
              </script>";
    } else {
        echo "<script>
                alert('Kļūda: " . $conn->error . "');
                window.history.back();
              </script>";
    }

    // Aizver sagatavoto paziņojumu
    $stmt->close();
}

// Aizver datubāzes savienojumu
$conn->close();
?>
